/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.level;

import com.mojang.datafixers.util.Pair;
import dev.compactmods.machines.client.level.RenderingLevel;
import dev.compactmods.machines.client.level.TemplateChunk;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.NotNull;

public class TemplateChunkProvider
extends ChunkSource {
    private final Map<ChunkPos, ChunkAccess> chunks;
    private final RenderingLevel world;
    private final LevelLightEngine lightManager;

    public TemplateChunkProvider(List<StructureTemplate.StructureBlockInfo> blocks, RenderingLevel world, Predicate<BlockPos> shouldShow) {
        this.world = world;
        this.lightManager = new LevelLightEngine((LightChunkGetter)this, true, true);
        HashMap<BlockPos, StructureTemplate.StructureBlockInfo> blockInfo = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        blocks.forEach(sbi -> blockInfo.put(sbi.f_74675_, (StructureTemplate.StructureBlockInfo)sbi));
        this.chunks = this.loadChunkData(blockInfo, world, shouldShow);
    }

    @NotNull
    private Map<ChunkPos, ChunkAccess> loadChunkData(Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks, RenderingLevel world, Predicate<BlockPos> shouldShow) {
        HashMap<ChunkPos, Map> byChunk = new HashMap<ChunkPos, Map>();
        for (Map.Entry<BlockPos, StructureTemplate.StructureBlockInfo> info : blocks.entrySet()) {
            Map bc = byChunk.computeIfAbsent(new ChunkPos(info.getKey()), $ -> new HashMap());
            bc.put(info.getKey(), info.getValue());
        }
        return byChunk.entrySet().stream().map(e -> Pair.of((Object)((ChunkPos)e.getKey()), (Object)((Object)new TemplateChunk(world, (ChunkPos)e.getKey(), (Map)e.getValue(), shouldShow)))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public Stream<ChunkAccess> chunks() {
        return this.chunks.values().stream();
    }

    @Nullable
    public ChunkAccess m_7587_(int chunkX, int chunkZ, @Nonnull ChunkStatus requiredStatus, boolean load) {
        return this.chunks.computeIfAbsent(new ChunkPos(chunkX, chunkZ), p -> new EmptyLevelChunk((Level)this.world, p, this.world.m_203675_(0, 0, 0)));
    }

    public void m_201698_(BooleanSupplier p_202162_, boolean p_202163_) {
    }

    @Nonnull
    public String m_6754_() {
        return "?";
    }

    public int m_142061_() {
        return 0;
    }

    @Nonnull
    public LevelLightEngine m_7827_() {
        return this.lightManager;
    }

    @Nonnull
    public BlockGetter m_7653_() {
        return this.world;
    }
}

